package li.rudin.core.security;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@InterceptorBinding
public @interface Restricted {
	
	/**
	 * The allowed roles
	 * @return
	 */
	@Nonbinding String[] roles() default {};
	
	/**
	 * The allowed users
	 * @return
	 */
	@Nonbinding String[] users() default {};
	
	/**
	 * Log all unsuccessful tries
	 * @return
	 */
	@Nonbinding boolean logViolations() default false;
}
