package li.rudin.core.security.service;

import java.util.List;

import li.rudin.core.security.User;


public interface UserService
{
	
	/**
	 * Returns all users
	 * @param name
	 * @return
	 */
	List<User> findAll();
	
	/**
	 * Returns the user by the id
	 * @param name
	 * @return
	 */
	User findById(long id);
	
	/**
	 * Returns the users by the name
	 * @param name
	 * @return
	 */
	List<User> findByName(String name);
	
	/**
	 * updates an existing user with changed roles or hash
	 * @param user
	 */
	void save(User user);
	
	/**
	 * Removes a user
	 * @param user
	 */
	void remove(User user);

}
