package li.rudin.core.security;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import li.rudin.core.security.exception.NotAllowedException;

@ApplicationScoped
public class SecurityChecker
{

	@Inject ProperSecuredBean secureBean;
	
	/**
	 * Tests whether the security interceptor is in place or not
	 * @return
	 */
	public boolean isSecure()
	{
		try
		{
			secureBean.unauthrizedMethod();
			return false;
		}
		catch (NotAllowedException e)
		{
			return true;
		}
		
	}
	
	@ApplicationScoped
	public static class ProperSecuredBean
	{
		@Restricted
		public void unauthrizedMethod(){}
	}
}
