package li.rudin.core.security.exception;

import java.lang.reflect.Method;

import li.rudin.core.security.User;

public class NotAllowedException extends RuntimeException
{
	public NotAllowedException(User user, Class<?> targetClass, Method method)
	{
		super("User: " + user.getName() + " is not allowed to invoke: " + targetClass.getName() + "." + method.getName());
		
		this.user = user;
		this.targetClass = targetClass;
		this.method = method;
	}
	
	public User getUser()
	{
		return user;
	}

	public Class<?> getTargetClass()
	{
		return targetClass;
	}

	public Method getMethod()
	{
		return method;
	}

	private final User user;
	
	private final Class<?> targetClass;
	
	private final Method method;
}
