package li.rudin.core.security.exception;

import java.lang.reflect.Method;

public class NotAllowedException extends RuntimeException
{
	public NotAllowedException(Class<?> targetClass, Method method)
	{
		super("User is not allowed to invoke: " + targetClass.getName() + "." + method.getName());
		
		this.targetClass = targetClass;
		this.method = method;
	}
	
	public Class<?> getTargetClass()
	{
		return targetClass;
	}

	public Method getMethod()
	{
		return method;
	}
	
	private final Class<?> targetClass;
	
	private final Method method;
}
