package li.rudin.core.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class User implements Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -6872437389257879905L;

	/**
	 * Anonymous user
	 */
	public static final User ANONYMOUS_USER = new User("anonymous", "");

	
	public User(){}
	
	public User(String name, String hash, String...roles)
	{
		this.name = name;
		this.hash = hash;
		
		for (String role: roles)
			this.roles.add(role);
	}

	private Long id;
	
	private String name, hash;
	
	public Set<String> getRoles()
	{
		return roles;
	}
	
	private final Set<String> roles = new HashSet<>();

	public String getName()
	{
		return name;
	}

	public String getHash()
	{
		return hash;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public void setHash(String hash)
	{
		this.hash = hash;
	}

	public Long getId()
	{
		return id;
	}

	public void setId(Long id)
	{
		this.id = id;
	}

}
