package li.rudin.cdi.security.jooq.service;

import static li.rudin.cdi.security.jooq.schema.tables.User.USER;

import java.util.ArrayList;
import java.util.List;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import li.rudin.cdi.security.jooq.schema.tables.records.UserRecord;
import li.rudin.core.security.User;
import li.rudin.core.security.service.UserService;

import org.jooq.DSLContext;
import org.jooq.Result;

@ApplicationScoped
public class JooqUserServiceImpl implements UserService
{

	@Inject DSLContext ctx;

	private List<User> toUsers(Result<UserRecord> records)
	{
		List<User> users = new ArrayList<>();

		for (UserRecord record: records)
		{
			User user = new User(
					record.getName(),
					record.getHash(),
					record.getRoles().split(",")
					);
			user.setId(record.getId());

			users.add(user);
		}

		return users;
	}

	@Override
	public List<User> findAll()
	{
		return toUsers(ctx
				.selectFrom(USER)
				.fetch());
	}

	@Override
	public User findById(long id)
	{
		Result<UserRecord> result = ctx
		.selectFrom(USER)
		.where(USER.ID.eq(id))
		.fetch();
		
		List<User> users = toUsers(result);
		
		if (users.isEmpty())
			return null;
		else
			return users.get(0);
	}

	@Override
	public List<User> findByName(String name)
	{
		return toUsers(ctx
				.selectFrom(USER)
				.where( USER.NAME.eq(name) )
				.fetch());
	}

	@Override
	public void save(User user)
	{

		UserRecord userRecord = ctx.newRecord(USER);
		userRecord.from(user);

		String roleString = "";
		for (String role: user.getRoles())
			roleString += role + ",";

		roleString = roleString.substring(0, roleString.length()-1);
		userRecord.setRoles(roleString);

		if (user.getId() == null)
			//new
			userRecord.insert();
		else
			//existing
			userRecord.update();

		//Save back id
		user.setId( userRecord.getId() );

	}

	@Override
	public void remove(User user)
	{
		ctx
		.delete(USER)
		.where( USER.ID.eq(user.getId()) )
		.execute();
	}

}
