/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.cdi.security.jooq.service;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import li.rudin.cdi.security.jooq.schema.tables.User;
import li.rudin.cdi.security.jooq.schema.tables.records.UserRecord;
import li.rudin.core.security.service.UserService;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.Table;

@ApplicationScoped
public class JooqUserServiceImpl
implements UserService {
    @Inject
    DSLContext ctx;

    private List<li.rudin.core.security.User> toUsers(Result<UserRecord> records) {
        ArrayList<li.rudin.core.security.User> users = new ArrayList<li.rudin.core.security.User>();
        for (UserRecord record : records) {
            li.rudin.core.security.User user = new li.rudin.core.security.User(record.getName(), record.getHash(), record.getRoles().split(","));
            user.setId(record.getId());
            users.add(user);
        }
        return users;
    }

    public List<li.rudin.core.security.User> findAll() {
        return this.toUsers((Result<UserRecord>)this.ctx.selectFrom((Table)User.USER).fetch());
    }

    public li.rudin.core.security.User findById(long id) {
        Result result = this.ctx.selectFrom((Table)User.USER).where(new Condition[]{User.USER.ID.eq((Object)id)}).fetch();
        List<li.rudin.core.security.User> users = this.toUsers((Result<UserRecord>)result);
        if (users.isEmpty()) {
            return null;
        }
        return users.get(0);
    }

    public List<li.rudin.core.security.User> findByName(String name) {
        return this.toUsers((Result<UserRecord>)this.ctx.selectFrom((Table)User.USER).where(new Condition[]{User.USER.NAME.eq((Object)name)}).fetch());
    }

    public void save(li.rudin.core.security.User user) {
        UserRecord userRecord = (UserRecord)this.ctx.newRecord((Table)User.USER);
        userRecord.from(user);
        String roleString = "";
        for (String role : user.getRoles()) {
            roleString = roleString + role + ",";
        }
        roleString = roleString.substring(0, roleString.length() - 1);
        userRecord.setRoles(roleString);
        if (user.getId() == null) {
            userRecord.insert();
        } else {
            userRecord.update();
        }
        user.setId(userRecord.getId());
    }

    public void remove(li.rudin.core.security.User user) {
        this.ctx.delete((Table)User.USER).where(new Condition[]{User.USER.ID.eq((Object)user.getId())}).execute();
    }
}

