/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.cdi.security.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import li.rudin.cdi.security.UserProvider;
import li.rudin.core.security.User;
import li.rudin.core.security.service.UserService;

@ApplicationScoped
public class StaticUserServiceImpl
implements UserService {
    @Inject
    Instance<UserProvider> userProviders;
    private final List<User> users = new ArrayList<User>();

    @PostConstruct
    void init() {
        for (UserProvider p : this.userProviders) {
            this.users.addAll(p.getUsers());
        }
    }

    public List<User> findAll() {
        return this.users;
    }

    public User findById(long id) {
        for (User u : this.users) {
            if (u.getId() == null || u.getId() != id) continue;
            return u;
        }
        return null;
    }

    public List<User> findByName(String name) {
        ArrayList<User> result = new ArrayList<User>();
        for (User u : this.users) {
            if (!u.getName().equals(name)) continue;
            result.add(u);
        }
        return result;
    }

    public void save(User user) {
        throw new IllegalArgumentException("not implemented in static user list");
    }

    public void remove(User user) {
        throw new IllegalArgumentException("not implemented in static user list");
    }
}

