package li.rudin.cdi.security.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

import li.rudin.cdi.security.UserProvider;
import li.rudin.core.security.User;
import li.rudin.core.security.service.UserService;

@ApplicationScoped
public class StaticUserServiceImpl implements UserService
{

	@Inject Instance<UserProvider> userProviders;
	
	private final List<User> users = new ArrayList<>();
	
	@PostConstruct
	void init()
	{
		for (UserProvider p: userProviders)
			users.addAll(p.getUsers());
	}
	
	@Override
	public List<User> findAll()
	{
		return users;
	}

	@Override
	public User findById(long id)
	{
		for (User u: users)
			if (u.getId() != null && u.getId() == id)
				return u;
		
		return null;
	}

	@Override
	public List<User> findByName(String name)
	{
		List<User> result = new ArrayList<>();
		
		for (User u: users)
			if (u.getName().equals(name))
				result.add(u);
		
		return result;
	}

	@Override
	public void save(User user)
	{
		throw new IllegalArgumentException("not implemented in static user list");
	}

	@Override
	public void remove(User user)
	{
		throw new IllegalArgumentException("not implemented in static user list");
	}

}
