package li.rudin.core.security.impl.user.context;

import javax.enterprise.context.ApplicationScoped;

import li.rudin.core.security.User;

@ApplicationScoped
public class ThreadLocalCurrentUser implements ContextBasedUser
{
	
	private ThreadLocal<User> user = new ThreadLocal<User>(){
		@Override
		public User initialValue()
		{
			return User.ANONYMOUS_USER;
		}
	};

	@Override
	public User get()
	{
		return user.get();
	}
	
	@Override
	public void set(User user)
	{
		this.user.set(user);
	}
	
}
