/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.io.Serializable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import li.rudin.core.security.Restricted;
import li.rudin.core.security.User;
import li.rudin.core.security.exception.NotAllowedException;
import li.rudin.core.security.service.CurrentUser;
import org.slf4j.Logger;

@Interceptor
@Restricted
@Priority(value=100)
public class RestrictionInterceptor
implements Serializable {
    @Inject
    CurrentUser currentUser;
    @Inject
    Logger logger;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        User user;
        Restricted restricted = ctx.getMethod().getAnnotation(Restricted.class);
        if (restricted == null) {
            restricted = ctx.getMethod().getDeclaringClass().getAnnotation(Restricted.class);
        }
        if ((user = this.currentUser.get()) == null) {
            throw new IllegalArgumentException("not logged in");
        }
        boolean authorized = false;
        block0: for (String availableRole : user.getRoles()) {
            for (String requiredRole : restricted.roles()) {
                if (!availableRole.equals(requiredRole)) continue;
                authorized = true;
                continue block0;
            }
        }
        if (!authorized) {
            for (String requiredUsername : restricted.users()) {
                if (!requiredUsername.equals(user.getName())) continue;
                authorized = true;
                break;
            }
        }
        if (!authorized) {
            String accessPoint = ctx.getMethod().getDeclaringClass().getName() + "." + ctx.getMethod().getName();
            if (restricted.logViolations()) {
                this.logger.warn("User {} tried to access {} without success", (Object)user.getName(), (Object)accessPoint);
            }
            throw new NotAllowedException(user, ctx.getMethod().getDeclaringClass(), ctx.getMethod());
        }
        Object result = ctx.proceed();
        return result;
    }
}

