/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl.user;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;
import li.rudin.core.security.User;
import li.rudin.core.security.impl.user.context.ContextBasedUser;
import li.rudin.core.security.impl.user.context.SessionScopedCurrentUser;
import li.rudin.core.security.impl.user.context.ThreadLocalCurrentUser;
import li.rudin.core.security.service.CurrentUser;

@ApplicationScoped
public class CurrentUserManager
implements CurrentUser {
    @Inject
    SessionScopedCurrentUser sessionUser;
    @Inject
    ThreadLocalCurrentUser threadUser;

    private ContextBasedUser getContextBasedUser() {
        try {
            this.sessionUser.get();
            return this.sessionUser;
        }
        catch (ContextNotActiveException e) {
            return this.threadUser;
        }
    }

    public User get() {
        return this.getContextBasedUser().get();
    }

    public void set(User user) {
        if (user == null) {
            this.getContextBasedUser().set(User.ANONYMOUS_USER);
        } else {
            this.getContextBasedUser().set(user);
        }
    }

    public boolean loggedIn() {
        return this.getContextBasedUser().get() != User.ANONYMOUS_USER;
    }

    public void logout() {
        this.getContextBasedUser().set(User.ANONYMOUS_USER);
    }
}

