package li.rudin.core.security.impl.user;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;

import li.rudin.core.security.User;
import li.rudin.core.security.impl.user.context.ContextBasedUser;
import li.rudin.core.security.impl.user.context.SessionScopedCurrentUser;
import li.rudin.core.security.impl.user.context.ThreadLocalCurrentUser;
import li.rudin.core.security.service.CurrentUser;

@ApplicationScoped
public class CurrentUserManager implements CurrentUser
{
	
	@Inject SessionScopedCurrentUser sessionUser;
	@Inject ThreadLocalCurrentUser threadUser;

	/**
	 * Returns the active currentUser implementation
	 * 
	 * @return
	 */
	private ContextBasedUser getContextBasedUser()
	{
		try
		{
			//Session based user
			sessionUser.get();
			
			return sessionUser;
		}
		catch (ContextNotActiveException e)
		{
			//No session context active
			
			//thread based user
			return threadUser;
		}
	}
	
	@Override
	public User get()
	{
		return getContextBasedUser().get();
	}

	@Override
	public void set(User user)
	{
		if (user == null)
			getContextBasedUser().set(User.ANONYMOUS_USER);
		else
			getContextBasedUser().set(user);
	}

	@Override
	public boolean loggedIn()
	{
		return (getContextBasedUser().get() != User.ANONYMOUS_USER);
	}

	@Override
	public void logout()
	{
		getContextBasedUser().set(User.ANONYMOUS_USER);
	}

}
