/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import li.rudin.core.security.Restricted;
import li.rudin.core.security.RestrictionHandler;
import li.rudin.core.security.User;
import li.rudin.core.security.service.CurrentUser;

@ApplicationScoped
public class DefaultRestrictionHandler
implements RestrictionHandler {
    @Inject
    CurrentUser currentUser;

    public boolean isAllowed(Restricted restricted, Class<?> type, Method method) {
        if (restricted.roles().length == 0 && restricted.users().length == 0) {
            return true;
        }
        User user = this.currentUser.get();
        for (String availableRole : user.getRoles()) {
            for (String requiredRole : restricted.roles()) {
                if (!availableRole.equals(requiredRole)) continue;
                return true;
            }
        }
        for (String requiredUsername : restricted.users()) {
            if (!requiredUsername.equals(user.getName())) continue;
            return true;
        }
        return false;
    }
}

