/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import li.rudin.core.security.Restricted;
import li.rudin.core.security.RestrictionHandler;
import li.rudin.core.security.exception.NotAllowedException;
import org.slf4j.Logger;

@Interceptor
@Restricted
@Priority(value=100)
public class RestrictionInterceptor
implements Serializable {
    private static final long serialVersionUID = 502796573808243808L;
    @Inject
    Logger logger;
    @Inject
    BeanManager beanManager;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Method method = ctx.getMethod();
        Class<?> type = method.getDeclaringClass();
        List<Restricted> list = this.getRestrictedAnnotation(method);
        Class restrictionHandler = list.get(0).restrictionHandler();
        Set beans = this.beanManager.getBeans((Type)restrictionHandler, new Annotation[0]);
        for (Bean bean : beans) {
            CreationalContext createCreationalContext;
            Object object = this.beanManager.getReference(bean, (Type)restrictionHandler, createCreationalContext = this.beanManager.createCreationalContext((Contextual)bean));
            if (!(object instanceof RestrictionHandler)) continue;
            RestrictionHandler handler = (RestrictionHandler)object;
            for (Restricted restricted : list) {
                if (handler.isAllowed(restricted, type, method)) continue;
                throw new NotAllowedException(type, ctx.getMethod());
            }
            return ctx.proceed();
        }
        throw new IllegalArgumentException("could not find RestrictionHandler");
    }

    private List<Restricted> getRestrictedAnnotation(Method method) {
        ArrayList<Restricted> list = new ArrayList<Restricted>();
        Class<?> type = method.getDeclaringClass();
        Restricted restricted = method.getAnnotation(Restricted.class);
        if (restricted != null) {
            list.add(restricted);
        }
        if ((restricted = type.getAnnotation(Restricted.class)) != null) {
            list.add(restricted);
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.getRestrictedAnnotationFromInterface(list, iface, method);
        }
        return list;
    }

    private void getRestrictedAnnotationFromInterface(List<Restricted> list, Class<?> iface, Method method) {
        Restricted restricted = iface.getAnnotation(Restricted.class);
        if (restricted != null) {
            list.add(restricted);
        }
        for (Class<?> subInterfaces : iface.getInterfaces()) {
            this.getRestrictedAnnotationFromInterface(list, subInterfaces, method);
        }
        try {
            Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
            restricted = ifaceMethod.getAnnotation(Restricted.class);
            if (restricted != null) {
                list.add(restricted);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

