package li.rudin.core.util.args;

import java.util.HashMap;
import java.util.Map;

public class ArgumentParser
{
	
	/**
	 * Creates a new argument parser
	 * @param args
	 */
	public ArgumentParser(String[] args)
	{
		String key = null;
		
		for (int i=0; i<args.length; i++)
		{
			String arg = args[i];
			
			if (arg.startsWith("-") && arg.length() > 1)
			{
				//argument key
				key = arg.substring(1);
				
				//Store as value-less key
				arguments.put(key, null);
			}
			else
			{
				//value
				if (key != null)
				{
					//Use previously stored key
					arguments.put(key, arg);
					
					//clear key
					key = null;
				}
			}
		}
	}
	
	/**
	 * The parsed arguments
	 */
	private final Map<String, String> arguments = new HashMap<>();
	
	
	/**
	 * Returns all arguments
	 * @return
	 */
	public Map<String, String> getArguments()
	{
		return arguments;
	}
	
	/**
	 * Returns the value or null if none found
	 * @param name
	 * @return
	 */
	public String get(String name)
	{
		return arguments.get(name);
	}
	
	/**
	 * Returns true if the argument was specified
	 * @param name
	 * @return
	 */
	public boolean isPresent(String name)
	{
		return arguments.containsKey(name);
	}
	
	/**
	 * Returns the value or if empty or not found, the default value
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public String get(String name, String defaultValue)
	{
		String value = arguments.get(name);
		
		if (value == null || value.equals(""))
			return defaultValue;
		else
			return value;
	}
	
}
