package li.rudin.core.util.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import li.rudin.core.util.stream.progress.NoOpCallback;
import li.rudin.core.util.stream.progress.StreamProgressCallback;

public class StreamUtil
{
	
	/**
	 * Copies a stream
	 * @param input
	 * @param output
	 * @throws IOException
	 * @return bytes copied
	 */
	public static long copyStream(InputStream input, OutputStream output) throws IOException
	{
		return copyStream(input, output, new NoOpCallback());
	}
	
	/**
	 * Copies a stream with progress callback
	 * @param input
	 * @param output
	 * @throws IOException
	 * @return bytes copied
	 */
	public static long copyStream(InputStream input, OutputStream output, StreamProgressCallback callback) throws IOException
	{
		byte[] buffer = new byte[100*1024]; //100kb
		long bytes = 0;
		
		do
		{
			int count = input.read(buffer);
			if (count <= 0)
				break;
			
			output.write(buffer, 0, count);
			bytes += count;
			callback.streamProgress(bytes);
		}
		while(true);
		
		return bytes;
	}

}
