/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.util.args;

import java.util.HashMap;
import java.util.Map;

public class ArgumentParser {
    private final Map<String, String> arguments = new HashMap<String, String>();

    public ArgumentParser(String[] args) {
        String key = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-") && arg.length() > 1) {
                key = arg.substring(1);
                this.arguments.put(key, null);
                continue;
            }
            if (key == null) continue;
            this.arguments.put(key, arg);
            key = null;
        }
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String get(String name) {
        return this.arguments.get(name);
    }

    public boolean isPresent(String name) {
        return this.arguments.containsKey(name);
    }

    public String get(String name, String defaultValue) {
        String value = this.arguments.get(name);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }
}

