package li.rudin.core.cditest;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;

public class CDITestInitializer
{

	@Inject Instance<CDITestHook> hooks;

	public void before() throws Exception
	{
		for (CDITestHook hook: hooks)
			hook.before();
	}

	public void after()
	{
		for (CDITestHook hook: hooks)
		{
			try
			{
				hook.after();
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
	}
}
