package li.rudin.core.cditest;

import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

/**
 * Junit runner for cdi testcases
 * @see http://objectopia.com/2011/05/29/weld-junit-4-runner/
 * @author rut
 * @since 3.0
 *
 */
public class CDITestRunner extends BlockJUnit4ClassRunner
{
	private final Class<?> cl;
	private static final Weld weld = new Weld();
	private static WeldContainer container;
	
	@Override
	public void run(RunNotifier notifier) {
		super.run(notifier);
		
		CDITestInitializer initializer = container.instance().select(CDITestInitializer.class).get();
		initializer.after();
	}

	public CDITestRunner(Class<?> cl) throws InitializationError
	{
		super(cl);
		this.cl = cl;
		
		if (container == null)
			container = weld.initialize();
	}
	
	@Override
	protected Object createTest() throws Exception
	{	

		CDITestInitializer initializer = container.instance().select(CDITestInitializer.class).get();
		initializer.before();

		return container.instance().select(cl).get();
	}

}
