package li.rudin.core.cdi.producer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;

public class ExecutorServiceProducer
{

	/**
	 * Produces an executor service
	 * @return
	 */
	@Produces
	public static ExecutorService produceExecutorService()
	{
		return Executors.newCachedThreadPool();
	}
	
	/**
	 * Disposes an executor service
	 * @param service
	 */
	public static void disposeExecutorService(@Disposes ExecutorService service)
	{
		service.shutdown();
	}
	
}
