package li.rudin.core.cdi.config.impl;

import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

import li.rudin.core.cdi.config.CoreConfigService;

import org.slf4j.Logger;

@ApplicationScoped
@Named("coreConfig")
public class PropertyConfigImpl implements CoreConfigService
{

	@Inject Logger logger;

	private final Properties properties = new Properties();

	@PostConstruct
	public void init()
	{
		try
		{
			properties.load(PropertyConfigImpl.class.getResourceAsStream("/core.properties"));
		}
		catch (Exception e)
		{
			logger.error("init", e);
		}
	}


	@Override
	public String getVersion()
	{
		return properties.getProperty("version");
	}

}
