package li.rudin.core.cdi.config.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

import li.rudin.core.cdi.config.CoreConfigService;

import org.slf4j.Logger;

@ApplicationScoped
@Named("coreConfig")
public class PropertyConfigImpl implements CoreConfigService
{

	@Inject Logger logger;

	@PostConstruct
	public void init()
	{
		try
		{
			Properties properties = new Properties();
			properties.load(PropertyConfigImpl.class.getResourceAsStream("/core.properties"));
			
			version = properties.getProperty("version");
			
			SimpleDateFormat dateFormat = new SimpleDateFormat(properties.getProperty("timestamp.format"));
			buildDate = dateFormat.parse(properties.getProperty("timestamp"));
		}
		catch (Exception e)
		{
			logger.error("init", e);
		}
	}
	
	private String version;
	private Date buildDate;


	@Override
	public String getVersion()
	{
		return version;
	}
	
	@Override
	public Date getBuildDate()
	{
		return buildDate;
	}

}
