/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.cdi.config.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import li.rudin.core.cdi.config.CoreConfigService;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="coreConfig")
public class PropertyConfigImpl
implements CoreConfigService {
    @Inject
    Logger logger;
    private String version;
    private Date buildDate;

    @PostConstruct
    public void init() {
        try {
            Properties properties = new Properties();
            properties.load(PropertyConfigImpl.class.getResourceAsStream("/core.properties"));
            this.version = properties.getProperty("version");
            SimpleDateFormat dateFormat = new SimpleDateFormat(properties.getProperty("timestamp.format"));
            this.buildDate = dateFormat.parse(properties.getProperty("timestamp"));
        }
        catch (Exception e) {
            this.logger.error("init", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Date getBuildDate() {
        return this.buildDate;
    }
}

