/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.cdi.eager;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import li.rudin.core.cdi.eager.Eager;

public class EagerExtension
implements Extension {
    private List<Bean<?>> eagerBeansList = new ArrayList();

    public <T> void collect(@Observes ProcessBean<T> event) {
        if (event.getAnnotated().isAnnotationPresent(Eager.class) && event.getAnnotated().isAnnotationPresent(ApplicationScoped.class)) {
            this.eagerBeansList.add(event.getBean());
        }
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        for (Bean<?> bean : this.eagerBeansList) {
            beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean)).toString();
        }
    }
}

