/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import li.rudin.core.crypto.CryptoBase;

public class SHA1
extends CryptoBase {
    public static String digest(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1", "BC");
            byte[] bytes = digest.digest(message.getBytes());
            return SHA1.toHex(bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("digest failed", e);
        }
    }

    public static String digest(File file) {
        int bufferSize = 0x500000;
        if (file.length() < (long)bufferSize) {
            bufferSize = (int)file.length();
        }
        return SHA1.digest(file, bufferSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String digest(File file, int bufferSize) {
        try (FileInputStream input = new FileInputStream(file);){
            MessageDigest digest = MessageDigest.getInstance("SHA-1", "BC");
            byte[] buffer = new byte[bufferSize];
            while (true) {
                int count;
                if ((count = ((InputStream)input).read(buffer)) <= 0) {
                    String string = SHA1.toHex(digest.digest());
                    return string;
                }
                digest.update(buffer, 0, count);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("digest failed", e);
        }
    }
}

