package li.rudin.core.crypto.service.impl;

import javax.enterprise.context.ApplicationScoped;

import li.rudin.core.crypto.AES;
import li.rudin.core.crypto.SHA1;
import li.rudin.core.crypto.SHA256;
import li.rudin.core.crypto.service.CryptoService;

@ApplicationScoped
public class CryptoServiceImpl implements CryptoService
{

	@Override
	public String createSHA1Sum(String message)
	{
		return SHA1.digest(message);
	}

	@Override
	public String createSHA256Sum(String message)
	{
		return SHA256.digest(message);
	}

	@Override
	public String encryptAES(String message, String password)
	{
		return AES.encrypt(message, password);
	}

}
