package li.rudin.core.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;


public class SHA1 extends CryptoBase
{
	
	/**
	 * Creates a message digest
	 * @param message
	 * @return
	 */
	public static String digest(String message)
	{
		try
		{
			MessageDigest digest = MessageDigest.getInstance("SHA-1", "BC");
			byte[] bytes = digest.digest(message.getBytes());
			return toHex(bytes);
		}
		catch (Exception e)
		{
			throw new IllegalArgumentException("digest failed", e);
		}
		
	}
	
	
	/**
	 * Creates a hash from a file
	 * @param file
	 * @return
	 */
	public static String digest(File file)
	{
		//5 MB max
		int bufferSize = 1024*1024*5;
		
		//Adjust length if smaller
		if (file.length() < bufferSize)
			bufferSize = (int)file.length();
		
		return digest(file, bufferSize);
	}
	
	/**
	 * Creates a hash from a file with the given buffer size
	 * @param file
	 * @return
	 */
	public static String digest(File file, int bufferSize)
	{
		try (InputStream input = new FileInputStream(file))
		{

			MessageDigest digest = MessageDigest.getInstance("SHA-1", "BC");

			byte[] buffer = new byte[bufferSize];

			while(true)
			{
				int count = input.read(buffer);

				if (count <= 0)
					break;
				
				digest.update(buffer, 0, count);
			}

			return toHex(digest.digest());
		}
		catch (Exception e)
		{
			throw new IllegalArgumentException("digest failed", e);
		}
	}
}
