package li.rudin.core.db;

import javax.persistence.EntityManager;

public interface AutoversionDatabaseConfig
{
	/**
	 * Returns the name of the autoversioned db
	 * @return
	 */
	String getName();
	
	/**
	 * Returns the current version of the schema
	 * @return
	 */
	long getSchemaVersion(EntityManager em);
	
	/**
	 * Sets the new schema version
	 * @param em
	 */
	void setSchemaVersion(EntityManager em, long version);

	/**
	 * Returns the classpath resource with the db schema or null if none found (previous is latest)
	 * @param version 0 to n
	 * @return
	 */
	public String getSchema(long version);

}
