/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.db;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import li.rudin.core.cdi.eager.Eager;
import li.rudin.core.db.AutoversionDatabaseConfig;
import li.rudin.core.db.EntityManagerProducer;
import org.slf4j.Logger;

@ApplicationScoped
@Eager
public class DatabaseBoot {
    @Inject
    Instance<AutoversionDatabaseConfig> configs;
    @Inject
    EntityManagerProducer emProducer;
    @Inject
    Logger logger;

    @PostConstruct
    public void init() {
        Iterator it = this.configs.iterator();
        while (it.hasNext()) {
            this.init((AutoversionDatabaseConfig)it.next());
        }
    }

    private void injectSchema(EntityManager em, String schemaUrl) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        this.logger.info("Injecting script from url: {}", (Object)schemaUrl);
        em.createNativeQuery("runscript from 'classpath:" + schemaUrl + "';").executeUpdate();
        em.flush();
        tx.commit();
    }

    private void updateSchema(EntityManager em, AutoversionDatabaseConfig dbConfig, long version) throws Exception {
        String schemaUrl;
        while (DatabaseBoot.class.getResourceAsStream(schemaUrl = dbConfig.getSchema(version)) != null) {
            this.logger.debug("Found schema with version: {}", (Object)version);
            this.injectSchema(em, schemaUrl);
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            dbConfig.setSchemaVersion(em, version);
            tx.commit();
            this.logger.info("Updated database schema version: {}", (Object)version);
            ++version;
        }
    }

    public void init(AutoversionDatabaseConfig dbConfig) {
        this.logger.info("Setting up embedded database: {}", (Object)dbConfig.getName());
        EntityManager em = this.emProducer.getOrCreateEntityManager(dbConfig.getName());
        long version = -1L;
        try {
            version = dbConfig.getSchemaVersion(em);
        }
        catch (Exception e) {
            this.logger.info("Schema versioning not present, defaulting to 0");
        }
        ++version;
        try {
            this.updateSchema(em, dbConfig, version);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not update schema to version: " + version, e);
        }
    }
}

