package li.rudin.core.db;

import li.rudin.core.db.version.VersionInterface;

public interface AutoversionDatabaseConfig
{
	/**
	 * Returns the name of the autoversioned db
	 * @return
	 */
	String getName();
	
	/**
	 * Returns the classpath resource with the db schema or null if none found (previous is latest)
	 * @param version 0 to n
	 * @return
	 */
	String getSchema(long version);

	/**
	 * Returns the concrete version tracker entity, defined by the application
	 * @return
	 */
	Class<? extends VersionInterface> getVersionEntity();
}
