/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.db;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import li.rudin.core.cdi.eager.Eager;
import li.rudin.core.db.AutoversionDatabaseConfig;
import li.rudin.core.db.EntityManagerProducer;
import li.rudin.core.db.version.VersionInterface;
import org.slf4j.Logger;

@ApplicationScoped
@Eager
public class DatabaseBoot {
    @Inject
    Instance<AutoversionDatabaseConfig> configs;
    @Inject
    EntityManagerProducer emProducer;
    @Inject
    Logger logger;

    @PostConstruct
    public void init() {
        Iterator it = this.configs.iterator();
        while (it.hasNext()) {
            try {
                AutoversionDatabaseConfig config = (AutoversionDatabaseConfig)it.next();
                this.init(config);
            }
            catch (Exception e) {
                this.logger.error("init", (Throwable)e);
                throw new IllegalArgumentException("init", e);
            }
        }
    }

    private void injectSchema(EntityManager em, String schemaUrl) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        this.logger.info("Injecting script from url: {}", (Object)schemaUrl);
        em.createNativeQuery("runscript from 'classpath:" + schemaUrl + "';").executeUpdate();
        tx.commit();
    }

    private void updateSchema(EntityManager em, AutoversionDatabaseConfig dbConfig, VersionInterface version) throws Exception {
        String schemaUrl;
        while (DatabaseBoot.class.getResourceAsStream(schemaUrl = dbConfig.getSchema(version.getVersion())) != null) {
            this.logger.debug("Found schema with version: {}", (Object)version);
            this.injectSchema(em, schemaUrl);
            this.logger.info("Updated database schema version: {}", (Object)version);
            version.setVersion(version.getVersion() + 1L);
        }
    }

    public void init(AutoversionDatabaseConfig dbConfig) throws Exception {
        this.logger.info("Setting up embedded database: {}", (Object)dbConfig.getName());
        EntityManager em = this.emProducer.getOrCreateEntityManager(dbConfig.getName());
        Class<? extends VersionInterface> versionType = dbConfig.getVersionEntity();
        VersionInterface version = null;
        try {
            version = (VersionInterface)em.find(versionType, (Object)0L);
            version.setVersion(version.getVersion() + 1L);
        }
        catch (Exception e) {
            this.logger.info("Schema versioning not present, defaulting to 0");
            version = versionType.newInstance();
        }
        try {
            this.updateSchema(em, dbConfig, version);
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            if (em.contains((Object)version)) {
                em.merge((Object)version);
            } else {
                em.persist((Object)version);
            }
            em.flush();
            tx.commit();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not update schema to version: " + version.getVersion(), e);
        }
    }
}

