package li.rudin.core.jaxrs.impl.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//@WebFilter(urlPatterns="/api/*")
public class CORSFilter implements Filter {

	@Override
	public void destroy() {}

	//https://github.com/Atmosphere/atmosphere/wiki/Enabling-CORS
	//http://padcom13.blogspot.ch/2011/09/cors-filter-for-java-applications.html
	
	//http://stackoverflow.com/questions/298745/how-do-i-send-a-cross-domain-post-request-via-javascript

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
	{
		HttpServletRequest req = (HttpServletRequest)request;                                   
		HttpServletResponse res = (HttpServletResponse)response;  

		res.addHeader("Access-Control-Allow-Origin", "*");
		res.addHeader("Access-Control-Allow-Methods", "GET, PUT, POST, DELETE, OPTIONS");
		res.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization, X-Requested-With");
		
		chain.doFilter(req, res);
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {}

}
