/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.jooq.impl;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import li.rudin.core.jooq.api.DatabaseConfiguration;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationProducer
implements ConnectionProvider {
    @Inject
    Logger logger;
    @Inject
    DatabaseConfiguration dbConfig;
    private DSLContext ctx;
    private Configuration configuration;
    private ComboPooledDataSource dataSource;

    @PostConstruct
    void init() {
        this.ctx = DSL.using((SQLDialect)SQLDialect.H2);
        this.configuration = this.ctx.configuration();
        this.configuration.set((ConnectionProvider)this);
        try {
            this.dataSource = new ComboPooledDataSource();
            this.dataSource.setDriverClass("org.h2.Driver");
            this.dataSource.setUser("sa");
            this.dataSource.setPassword("");
            this.dataSource.setJdbcUrl(this.dbConfig.getDatabaseUrl());
            this.dataSource.setMinPoolSize(5);
            this.dataSource.setAcquireIncrement(5);
            this.dataSource.setMaxPoolSize(50);
        }
        catch (Exception e) {
            this.logger.error("init", (Throwable)e);
            throw new IllegalArgumentException("init", e);
        }
    }

    @PreDestroy
    void destroy() {
        this.dataSource.close();
    }

    @Produces
    public Configuration produceConfiguration(InjectionPoint p) {
        return this.configuration;
    }

    public Connection acquire() throws DataAccessException {
        return this.produceConnection();
    }

    public void release(Connection connection) throws DataAccessException {
        this.disposeConnection(connection);
    }

    @Produces
    public Connection produceConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("acquire", e);
        }
    }

    public void disposeConnection(@Disposes Connection connection) {
        try {
            connection.close();
            this.logger.debug("closed connection: {}", (Object)connection.hashCode());
        }
        catch (SQLException e) {
            this.logger.error("release", (Throwable)e);
        }
    }
}

