package li.rudin.core.jpa;

import li.rudin.core.jpa.version.VersionInterface;

public interface AutoversionDatabaseConfig
{
	
	/**
	 * Returns the classpath resource with the db schema or null if none found (previous is latest)
	 * Example: String.format("/schema/schema%03d.sql", version); 3 = schema003.sql
	 * @param version 0 to n
	 * @return
	 */
	String getSchema(long version);

	/**
	 * Returns the concrete version tracker entity, defined by the application
	 * @return
	 */
	Class<? extends VersionInterface> getVersionEntity();
}
