package li.rudin.core.scheduler;

import javax.enterprise.inject.spi.CDI;

import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;


public class CDIJobFactory implements JobFactory
{
	
	//private static final Logger logger = LoggerFactory.getLogger(CDIJobFactory.class);

	@Override
	public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException
	{

		Class<? extends Job> jobClass = bundle.getJobDetail().getJobClass();
		
		Job instance = CDI.current().select(jobClass).get();

		return instance;
	}

}
