package li.rudin.core.scheduler.extension;

import javax.enterprise.inject.spi.CDI;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIJob implements Job
{
	
	public static final String JOB_MAP_CLASS_NAME = "className";
	private static final Logger logger = LoggerFactory.getLogger(CDIJob.class);

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException
	{
		
		String className = context.getJobDetail().getJobDataMap().getString(JOB_MAP_CLASS_NAME);
		
		try
		{
			Class<? extends Runnable> type = Class.forName(className).asSubclass(Runnable.class);
			
			Runnable instance = CDI.current().select(type).get();
			
			instance.run();
		}
		catch (ClassNotFoundException e)
		{
			logger.error("execute", e);
			throw new JobExecutionException(e);
		}
	}


}
