/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.scheduler.extension;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import li.rudin.core.scheduler.annotation.Schedule;
import li.rudin.core.scheduler.extension.CDIJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleExtension
implements Extension {
    private Scheduler scheduler;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleExtension.class);

    public void init(@Observes BeforeBeanDiscovery event) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> void collect(@Observes ProcessBean<T> event) {
        try {
            Annotated annotated = event.getAnnotated();
            if (annotated.isAnnotationPresent(Schedule.class) && annotated.isAnnotationPresent(ApplicationScoped.class)) {
                Bean bean = event.getBean();
                JobDetail detail = JobBuilder.newJob(CDIJob.class).usingJobData("className", bean.getBeanClass().getName()).build();
                Schedule scheduleAnnotation = (Schedule)annotated.getAnnotation(Schedule.class);
                String cronString = scheduleAnnotation.seconds() + " " + scheduleAnnotation.minutes() + " " + scheduleAnnotation.hours() + " " + scheduleAnnotation.daysOfMonth() + " " + scheduleAnnotation.months() + " " + scheduleAnnotation.daysOfWeek() + " " + scheduleAnnotation.years();
                logger.info("Scheduling job '{}' on '{}'", (Object)bean.getBeanClass().getName(), (Object)cronString);
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(bean.getBeanClass().getName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).forJob(detail).build();
                this.scheduler.scheduleJob(detail, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            event.addDefinitionError((Throwable)e);
        }
    }

    public void start(@Observes AfterDeploymentValidation event) {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            event.addDeploymentProblem((Throwable)e);
        }
    }

    public void stop(@Observes BeforeShutdown event) {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

