/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.scheduler.extension;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import li.rudin.core.scheduler.annotation.Schedule;
import li.rudin.core.scheduler.extension.CDIJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleExtension
implements Extension {
    private Scheduler scheduler;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleExtension.class);

    public void init(@Observes BeforeBeanDiscovery event) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void scheduleCronJob(Schedule scheduleAnnotation, Bean<?> bean) throws SchedulerException {
        String cronString = scheduleAnnotation.seconds() + " " + scheduleAnnotation.minutes() + " " + scheduleAnnotation.hours() + " " + scheduleAnnotation.daysOfMonth() + " " + scheduleAnnotation.months() + " " + scheduleAnnotation.daysOfWeek() + " " + scheduleAnnotation.years();
        JobDetail detail = JobBuilder.newJob(CDIJob.class).usingJobData("className", bean.getBeanClass().getName()).build();
        logger.info("Scheduling job '{}' on '{}'", (Object)bean.getBeanClass().getName(), (Object)cronString);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(bean.getBeanClass().getName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).forJob(detail).build();
        this.scheduler.scheduleJob(detail, (Trigger)trigger);
    }

    public <T> void collect(@Observes ProcessBean<T> event) {
        try {
            Annotated annotated = event.getAnnotated();
            Schedule scheduleAnnotation = this.getScheduleAnnotation(annotated.getAnnotations().toArray(new Annotation[annotated.getAnnotations().size()]), 2);
            if (scheduleAnnotation != null && annotated.isAnnotationPresent(ApplicationScoped.class)) {
                Bean bean = event.getBean();
                this.scheduleCronJob(scheduleAnnotation, bean);
            }
        }
        catch (Exception e) {
            event.addDefinitionError((Throwable)e);
        }
    }

    private Schedule getScheduleAnnotation(Annotation[] annotations, int levels) {
        if (levels == 0) {
            return null;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (type == Schedule.class) {
                return (Schedule)annotation;
            }
            Annotation[] subAnnotations = annotation.annotationType().getAnnotations();
            Schedule schedule = this.getScheduleAnnotation(subAnnotations, levels - 1);
            if (schedule == null) continue;
            return schedule;
        }
        return null;
    }

    public void start(@Observes AfterDeploymentValidation event) {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            event.addDeploymentProblem((Throwable)e);
        }
    }

    public void stop(@Observes BeforeShutdown event) {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

