package li.rudin.core.scheduler.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.quartz.CronExpression;


/**
 * Schedule annotation
 * Defaults to midnight every day
 * @see {@link CronExpression}
 * @return
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.PARAMETER})
public @interface Schedule
{
	/**
	 * The seconds to start the job in
	 * @return
	 */
	public String seconds() default "0";
	
	/**
	 * The minutes to start the job in
	 * @return
	 */
	public String minutes() default "0";
	
	/**
	 * The hours to start the job in
	 * @return
	 */
	public String hours() default "0";
	
	/**
	 * The daysOfMonth to start the job in
	 * @return
	 */
	public String daysOfMonth() default "*";
	
	/**
	 * The months to start the job in
	 * @return
	 */
	public String months() default "*";
	
	/**
	 * The daysOfWeek to start the job in
	 * @return
	 */
	public String daysOfWeek() default "?";
	
	/**
	 * The years to start the job in
	 * @return
	 */
	public String years() default "*";
	
}
