package li.rudin.core.security.impl;

import java.util.HashSet;
import java.util.Set;

import li.rudin.core.security.AbstractUser;

public class DefaultUser implements AbstractUser
{
	
	public DefaultUser(){}
	
	public DefaultUser(String name, String sha1, String...roles)
	{
		this.name = name;
		this.sha1 = sha1;
		
		for (String role: roles)
			this.roles.add(role);
	}

	private String name, sha1;
	
	@Override
	public Set<String> getRoles()
	{
		return roles;
	}
	
	private final Set<String> roles = new HashSet<>();

	@Override
	public String getName()
	{
		return name;
	}

	@Override
	public String getSha1()
	{
		return sha1;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	@Override
	public void setSha1(String sha1)
	{
		this.sha1 = sha1;
	}

}
