
-- Users

CREATE TABLE USER(
    ID BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY,
    NAME VARCHAR(255),
    SHA1 VARCHAR(40)
);

-- Role

CREATE TABLE ROLE(
    ID BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY,
    NAME VARCHAR(255)
);

-- UserRole

CREATE TABLE USER_ROLES(
    USER_ID BIGINT NOT NULL,
    ROLE_ID BIGINT NOT NULL
);

ALTER TABLE USER_ROLES ADD CONSTRAINT USER_ROLES_ID_KEY_Constraint PRIMARY KEY(USER_ID, ROLE_ID);             
ALTER TABLE USER_ROLES ADD CONSTRAINT USER_ROLES_ROLE_FK FOREIGN KEY(ROLE_ID) REFERENCES ROLE(ID) NOCHECK;
ALTER TABLE USER_ROLES ADD CONSTRAINT USER_ROLES_USER_FK FOREIGN KEY(USER_ID) REFERENCES USER(ID) NOCHECK;


-- Admin user with default pw
-- insert into USER(NAME, SHA1) values('admin', '3674951ec264a72168cb2d89a5f634e512f6629d');
-- insert into ROLE(NAME) values('admin');
-- insert into USER_ROLES(user_id, role_id) values( select id from user where name = 'admin', select id from role where name = 'admin' );

