/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import li.rudin.core.security.AbstractUser;
import li.rudin.core.security.UserService;
import li.rudin.core.security.impl.DefaultUser;
import li.rudin.core.security.impl.schema.tables.Role;
import li.rudin.core.security.impl.schema.tables.User;
import li.rudin.core.security.impl.schema.tables.UserRoles;
import li.rudin.core.security.impl.schema.tables.records.RoleRecord;
import li.rudin.core.security.impl.schema.tables.records.UserRecord;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;

@SessionScoped
public class LoginServiceImpl
implements UserService,
Serializable {
    public static final DefaultUser ANONYMOUS_USER = new DefaultUser("anonymous", "", new String[0]);
    private AbstractUser user = ANONYMOUS_USER;
    @Inject
    DSLContext ctx;

    public AbstractUser getUser() {
        return this.user;
    }

    public void login(AbstractUser user) {
        this.user = user;
    }

    public void logout() {
        this.user = ANONYMOUS_USER;
    }

    public boolean isLoggedIn() {
        return this.user != ANONYMOUS_USER;
    }

    public List<AbstractUser> findByName(String name) {
        Result records = this.ctx.select(User.USER.ID, User.USER.NAME, User.USER.SHA1, Role.ROLE.NAME).from(new TableLike[]{User.USER.as("u"), Role.ROLE.as("r"), UserRoles.USER_ROLES}).join((TableLike)User.USER).on(new Condition[]{User.USER.ID.eq(UserRoles.USER_ROLES.USER_ID)}).join((TableLike)Role.ROLE).on(new Condition[]{Role.ROLE.ID.eq(UserRoles.USER_ROLES.ROLE_ID)}).fetch();
        ArrayList<AbstractUser> list = new ArrayList<AbstractUser>();
        DefaultUser user = null;
        Long currentId = null;
        for (Record4 record : records) {
            Long id = (Long)record.getValue(User.USER.ID);
            if (currentId == null || currentId != id) {
                user = new DefaultUser();
                user.setName((String)record.getValue(User.USER.NAME));
                user.setSha1((String)record.getValue(User.USER.SHA1));
                list.add(user);
                currentId = id;
            }
            user.getRoles().add((String)record.getValue(Role.ROLE.NAME));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUser create(String name, String sha1, String ... roles) {
        DefaultUser user = new DefaultUser(name, sha1, roles);
        Long id = ((UserRecord)this.ctx.insertInto((Table)User.USER, User.USER.NAME, User.USER.SHA1).values((Object)name, (Object)sha1).returning(new Field[]{User.USER.ID}).fetchOne()).getId();
        Role role = Role.ROLE;
        synchronized (role) {
            for (String role2 : roles) {
                RoleRecord record = (RoleRecord)this.ctx.selectFrom((Table)Role.ROLE).where(new Condition[]{Role.ROLE.NAME.eq((Object)role2)}).fetchOne();
                if (record == null) {
                    record = (RoleRecord)this.ctx.insertInto((Table)Role.ROLE, Role.ROLE.NAME).values((Object)role2).returning(new Field[]{Role.ROLE.ID}).fetchOne();
                }
                this.ctx.insertInto((Table)UserRoles.USER_ROLES, UserRoles.USER_ROLES.USER_ID, UserRoles.USER_ROLES.ROLE_ID).values((Object)id, (Object)record.getId()).execute();
            }
        }
        return user;
    }

    public void remove(AbstractUser user) {
    }

    public void update(AbstractUser user) {
    }
}

