package li.rudin.core.security.impl;

import java.io.Serializable;

import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

import li.rudin.core.security.Credentials;
import li.rudin.core.security.Restricted;

import org.slf4j.Logger;

@Interceptor
@Restricted(roles="")
public class RestrictionInterceptor implements Serializable
{

	@Inject Credentials creds;
	@Inject Logger logger;
	
	@AroundInvoke
	public Object intercept(InvocationContext ctx) throws Exception
	{
		Restricted restricted = ctx.getMethod().getAnnotation(Restricted.class);

		String[] roles = restricted.roles();
		
		boolean authorized = false;
		
		for (String availableRole: creds.getRoles())
			for (String requireRole: roles)
				if (availableRole.equals(requireRole))
				{
					//Matching roles found
						authorized = true;
						break;
				}

		if (!authorized)
		{
			String accessPoint = ctx.getTarget().getClass().getName() + "." + ctx.getMethod().getName();
			
			logger.warn("User {} tried to access {} without success", creds.getUsername(), accessPoint);
			throw new IllegalArgumentException("User: " + creds.getUsername() + " is not authorized for: " + accessPoint);
		}

		//Proceed
		Object result = ctx.proceed();


		return result;

	}

}
