/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.io.Serializable;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import li.rudin.core.security.Credentials;
import li.rudin.core.security.Restricted;
import org.slf4j.Logger;

@Interceptor
@Restricted(roles={""})
public class RestrictionInterceptor
implements Serializable {
    @Inject
    Credentials creds;
    @Inject
    Logger logger;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Restricted restricted = ctx.getMethod().getAnnotation(Restricted.class);
        String[] roles = restricted.roles();
        boolean authorized = false;
        block0: for (String availableRole : this.creds.getRoles()) {
            for (String requireRole : roles) {
                if (!availableRole.equals(requireRole)) continue;
                authorized = true;
                continue block0;
            }
        }
        if (!authorized) {
            String accessPoint = ctx.getTarget().getClass().getName() + "." + ctx.getMethod().getName();
            this.logger.warn("User {} tried to access {} without success", (Object)this.creds.getUsername(), (Object)accessPoint);
            throw new IllegalArgumentException("User: " + this.creds.getUsername() + " is not authorized for: " + accessPoint);
        }
        Object result = ctx.proceed();
        return result;
    }
}

