/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.security.impl;

import java.io.Serializable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.Produces;
import li.rudin.core.security.LoginService;
import li.rudin.core.security.Restricted;
import li.rudin.core.security.user.User;
import org.slf4j.Logger;

@Interceptor
@Restricted
@Priority(value=100)
public class RestrictionInterceptor
implements Serializable {
    @Inject
    LoginService creds;
    @Inject
    Logger logger;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        User user;
        Restricted restricted = ctx.getMethod().getAnnotation(Restricted.class);
        if (restricted == null) {
            restricted = ctx.getMethod().getDeclaringClass().getAnnotation(Restricted.class);
        }
        if ((user = this.creds.getUser()) == null) {
            throw new IllegalArgumentException("not logged in");
        }
        boolean authorized = false;
        block0: for (String availableRole : user.getRoles()) {
            for (String requireRole : restricted.roles()) {
                if (!availableRole.equals(requireRole)) continue;
                authorized = true;
                continue block0;
            }
        }
        if (!authorized) {
            for (String requiredUsername : restricted.users()) {
                if (!requiredUsername.equals(user.getName())) continue;
                authorized = true;
                break;
            }
        }
        if (!authorized) {
            String accessPoint = ctx.getMethod().getDeclaringClass().getName() + "." + ctx.getMethod().getName();
            if (this.isJsonProducer(ctx)) {
                // empty if block
            }
            if (restricted.logViolations()) {
                this.logger.warn("User {} tried to access {} without success", (Object)user.getName(), (Object)accessPoint);
            }
            throw new IllegalArgumentException("User: " + user.getName() + " is not authorized for: " + accessPoint);
        }
        Object result = ctx.proceed();
        return result;
    }

    private boolean isJsonProducer(InvocationContext ctx) {
        Produces produces = ctx.getMethod().getAnnotation(Produces.class);
        if (produces == null) {
            produces = ctx.getMethod().getDeclaringClass().getAnnotation(Produces.class);
        }
        if (produces == null) {
            return false;
        }
        return produces.value().length == 1 && produces.value()[0].equals("application/json");
    }
}

