define(function(require){

	require("bootstrap");

	var MV = require("mv"),
		View = require("text!./View.html")
		$ = require("jquery"),
		Moment = require("moment");

	return function(cfg){
	
		this.html = View;

		var self = this;
		
		this.cfg = $.extend({
			/**
			 * default to current date
			 */
			date: new Date(),
			
			/**
			 * Date format
			 * http://momentjs.com/docs/#/displaying/format/
			 */
			dateFormat: "YYYY-MM-DD HH:mm:ss",
			
			/**
			 * The title
			 */
			title: "Time",
		}, cfg);
	
		
		/**
		 * Current date
		 */
		this.date = MV.observable(self.cfg.date);
		
		this.dateStr = MV.computed({
			read: function(){
				return moment(self.date()).format(self.cfg.dateFormat);
			},
			write: function(value){
				self.date( moment(value, self.cfg.dateFormat).toDate() );
			}
		});
	
		/**
		 * Creates a date add/sub function
		 */
		var dateFunction = function(millis){
			return function(){
				self.date( new Date(self.date().getTime() + millis) );
			};
		};
		
		this.minusMonth = dateFunction(-30*24*3600*1000);
		this.minusWeek = dateFunction(-7*24*3600*1000);
		this.minusDay = dateFunction(-24*3600*1000);
		this.minusHour = dateFunction(-3600*1000);
		this.plusHour = dateFunction(3600*1000);
		this.plusDay = dateFunction(24*3600*1000);
		this.plusWeek = dateFunction(7*24*3600*1000);
		this.plusMonth = dateFunction(30*24*3600*1000);
		
		/**
		 * Reset date to now
		 */
		this.now = function(){
			self.date( new Date() );
		};
	};
});