package li.rudin.rt.api.handler;

import li.rudin.rt.api.filter.RTFilter;
import li.rudin.rt.api.listener.RTListener;

public interface RTHandler extends RTSender
{

	/**
	 * Sets a filter instance
	 * @param filter
	 */
	void setFilter(RTFilter filter);
	
	/**
	 * Returns the set filter
	 * @return
	 */
	RTFilter getFilter();
	
	/**
	 * Adds a listener
	 * @param listener
	 */
	void addListener(RTListener listener);
	
	/**
	 * Removes a listener
	 * @param listener
	 */
	void removeListener(RTListener listener);
	
	/**
	 * Returns the id of the handler instance
	 * @return
	 */
	String getId();
	
	/**
	 * Returns the connected client count
	 * @return
	 */
	int getClientCount();
}
