package li.rudin.rt.api.computed;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import li.rudin.rt.api.observable.Listener;
import li.rudin.rt.api.observable.Observable;

public class Computed<T> implements ObservableAccessor, Listener<Object>
{
	public Computed(ComputedValue<T> cv)
	{
		this.cv = cv;
		recompute();
	}
	
	private final ComputedValue<T> cv;
	private T value;
	
	private boolean registerObservables = true;
	
	/**
	 * Returns the current value
	 * @return
	 */
	public T get()
	{
		return value;
	}
	
	/**
	 * Re-computes the value
	 */
	private void recompute()
	{
		T oldValue = value;
		
		value = cv.compute(this);
		registerObservables = false;
		
		for (Listener<T> l: listeners)
			l.onChange(oldValue, value);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <V> V get(Observable<V> o)
	{
		if (registerObservables)
			o.addListener((Listener<V>) this);
		
		return o.get();
	}

	@Override
	public void onChange(Object oldValue, Object newValue)
	{
		recompute();
	}
	
	/**
	 * All local listeners
	 */
	private List<Listener<T>> listeners = new CopyOnWriteArrayList<>();
	
	/**
	 * Adds a local listener
	 * @param l
	 */
	public void addListener(Listener<T> l)
	{
		listeners.add(l);
	}
	
	/**
	 * Removes the local listener
	 * @param l
	 */
	public void removeListener(Listener<T> l)
	{
		listeners.remove(l);
	}
}
